-- ==============================================================
-- Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC v2019.2.1 (64-bit)
-- Copyright 1986-2019 Xilinx, Inc. All Rights Reserved.
-- ==============================================================
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity fw_binned_bins_lut_rom is 
    generic(
             DWIDTH     : integer := 32; 
             AWIDTH     : integer := 6; 
             MEM_SIZE    : integer := 33
    ); 
    port (
          addr0      : in std_logic_vector(AWIDTH-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(DWIDTH-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of fw_binned_bins_lut_rom is 

signal addr0_tmp : std_logic_vector(AWIDTH-1 downto 0); 
type mem_array is array (0 to MEM_SIZE-1) of std_logic_vector (DWIDTH-1 downto 0); 
signal mem : mem_array := (
    0 => "00000000000000000000000000000000", 
    1 => "01000000001110011011001101111101", 
    2 => "01000000101110000000111110010001", 
    3 => "01000001000011001001011010011100", 
    4 => "01000001001110110010110101110111", 
    5 => "01000001011010001001111010000100", 
    6 => "01000001100011000101011110101000", 
    7 => "01000001101000111000111000100010", 
    8 => "01000001101110101000010110001000", 
    9 => "01000001110100101000110111101101", 
    10 => "01000001111010011100010001100111", 
    11 => "01000010000000000111001011100101", 
    12 => "01000010000011000110110010100101", 
    13 => "01000010000110000001001001010100", 
    14 => "01000010001000111001100010010011", 
    15 => "01000010001011110111110100111100", 
    16 => "01000010001110110001100001111001", 
    17 => "01000010010001101011001110110110", 
    18 => "01000010010100110101111111110011", 
    19 => "01000010010111101011110000011100", 
    20 => "01000010011010100000001101100001", 
    21 => "01000010011101011101001100001100", 
    22 => "01000010100000001100011011101001", 
    23 => "01000010100001101000111101000010", 
    24 => "01000010100011000111000111011110", 
    25 => "01000010100100100100100111111100", 
    26 => "01000010100101111110100001011000", 
    27 => "01000010100111010101001000111010", 
    28 => "01000010101000101100011010011011", 
    29 => "01000010101010001101001100110011", 
    30 => "01000010101011100011011111001111", 
    31 => "01000010101100111001000111101100", 
    32 => "01000010101110001110011011001111" );


begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem(CONV_INTEGER(addr0_tmp)); 
        end if;
    end if;
end process;

end rtl;

Library IEEE;
use IEEE.std_logic_1164.all;

entity fw_binned_bins_lut is
    generic (
        DataWidth : INTEGER := 32;
        AddressRange : INTEGER := 33;
        AddressWidth : INTEGER := 6);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of fw_binned_bins_lut is
    component fw_binned_bins_lut_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    fw_binned_bins_lut_rom_U :  component fw_binned_bins_lut_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0);

end architecture;


