// ==============================================================
// Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC v2019.2.1 (64-bit)
// Copyright 1986-2019 Xilinx, Inc. All Rights Reserved.
// ==============================================================
#ifndef __fw_binned_bins_lut_H__
#define __fw_binned_bins_lut_H__


#include <systemc>
using namespace sc_core;
using namespace sc_dt;




#include <iostream>
#include <fstream>

struct fw_binned_bins_lut_ram : public sc_core::sc_module {

  static const unsigned DataWidth = 32;
  static const unsigned AddressRange = 33;
  static const unsigned AddressWidth = 6;

//latency = 1
//input_reg = 1
//output_reg = 0
sc_core::sc_in <sc_lv<AddressWidth> > address0;
sc_core::sc_in <sc_logic> ce0;
sc_core::sc_out <sc_lv<DataWidth> > q0;
sc_core::sc_in<sc_logic> reset;
sc_core::sc_in<bool> clk;


sc_lv<DataWidth> ram[AddressRange];


   SC_CTOR(fw_binned_bins_lut_ram) {
        ram[0] = "0b00000000000000000000000000000000";
        ram[1] = "0b01000000001110011011001101111101";
        ram[2] = "0b01000000101110000000111110010001";
        ram[3] = "0b01000001000011001001011010011100";
        ram[4] = "0b01000001001110110010110101110111";
        ram[5] = "0b01000001011010001001111010000100";
        ram[6] = "0b01000001100011000101011110101000";
        ram[7] = "0b01000001101000111000111000100010";
        ram[8] = "0b01000001101110101000010110001000";
        ram[9] = "0b01000001110100101000110111101101";
        ram[10] = "0b01000001111010011100010001100111";
        ram[11] = "0b01000010000000000111001011100101";
        ram[12] = "0b01000010000011000110110010100101";
        ram[13] = "0b01000010000110000001001001010100";
        ram[14] = "0b01000010001000111001100010010011";
        ram[15] = "0b01000010001011110111110100111100";
        ram[16] = "0b01000010001110110001100001111001";
        ram[17] = "0b01000010010001101011001110110110";
        ram[18] = "0b01000010010100110101111111110011";
        ram[19] = "0b01000010010111101011110000011100";
        ram[20] = "0b01000010011010100000001101100001";
        ram[21] = "0b01000010011101011101001100001100";
        ram[22] = "0b01000010100000001100011011101001";
        ram[23] = "0b01000010100001101000111101000010";
        ram[24] = "0b01000010100011000111000111011110";
        ram[25] = "0b01000010100100100100100111111100";
        ram[26] = "0b01000010100101111110100001011000";
        ram[27] = "0b01000010100111010101001000111010";
        ram[28] = "0b01000010101000101100011010011011";
        ram[29] = "0b01000010101010001101001100110011";
        ram[30] = "0b01000010101011100011011111001111";
        ram[31] = "0b01000010101100111001000111101100";
        ram[32] = "0b01000010101110001110011011001111";


SC_METHOD(prc_write_0);
  sensitive<<clk.pos();
   }


void prc_write_0()
{
    if (ce0.read() == sc_dt::Log_1) 
    {
            if(address0.read().is_01() && address0.read().to_uint()<AddressRange)
              q0 = ram[address0.read().to_uint()];
            else
              q0 = sc_lv<DataWidth>();
    }
}


}; //endmodule


SC_MODULE(fw_binned_bins_lut) {


static const unsigned DataWidth = 32;
static const unsigned AddressRange = 33;
static const unsigned AddressWidth = 6;

sc_core::sc_in <sc_lv<AddressWidth> > address0;
sc_core::sc_in<sc_logic> ce0;
sc_core::sc_out <sc_lv<DataWidth> > q0;
sc_core::sc_in<sc_logic> reset;
sc_core::sc_in<bool> clk;


fw_binned_bins_lut_ram* meminst;


SC_CTOR(fw_binned_bins_lut) {
meminst = new fw_binned_bins_lut_ram("fw_binned_bins_lut_ram");
meminst->address0(address0);
meminst->ce0(ce0);
meminst->q0(q0);

meminst->reset(reset);
meminst->clk(clk);
}
~fw_binned_bins_lut() {
    delete meminst;
}


};//endmodule
#endif
