// ==============================================================
// Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC v2019.2.1 (64-bit)
// Copyright 1986-2019 Xilinx, Inc. All Rights Reserved.
// ==============================================================
#ifndef __fw_binned_binw_lut_H__
#define __fw_binned_binw_lut_H__


#include <systemc>
using namespace sc_core;
using namespace sc_dt;




#include <iostream>
#include <fstream>

struct fw_binned_binw_lut_ram : public sc_core::sc_module {

  static const unsigned DataWidth = 32;
  static const unsigned AddressRange = 32;
  static const unsigned AddressWidth = 5;

//latency = 1
//input_reg = 1
//output_reg = 0
sc_core::sc_in <sc_lv<AddressWidth> > address0;
sc_core::sc_in <sc_logic> ce0;
sc_core::sc_out <sc_lv<DataWidth> > q0;
sc_core::sc_in<sc_logic> reset;
sc_core::sc_in<bool> clk;


sc_lv<DataWidth> ram[AddressRange];


   SC_CTOR(fw_binned_binw_lut_ram) {
        ram[0] = "0b00111111000101001000111110010111";
        ram[1] = "0b00111111000100011110111110110111";
        ram[2] = "0b00111111000110110110001010100110";
        ram[3] = "0b00111111000101010001010111110000";
        ram[4] = "0b00111111000100010110100111000010";
        ram[5] = "0b00111111000110011100111101010111";
        ram[6] = "0b00111111000101001000111111011010";
        ram[7] = "0b00111111000100101111110000100110";
        ram[8] = "0b00111111000110011100111101010111";
        ram[9] = "0b00111111000101001000111111011010";
        ram[10] = "0b00111111000101000000100011011001";
        ram[11] = "0b00111111000110010100100110100101";
        ram[12] = "0b00111111000101010001010110001100";
        ram[13] = "0b00111111000100111000001100100111";
        ram[14] = "0b00111111000110000011101110100011";
        ram[15] = "0b00111111000101001000111111011010";
        ram[16] = "0b00111111000101001000111111011010";
        ram[17] = "0b00111111001000100011011000111011";
        ram[18] = "0b00111111000100010110100001110011";
        ram[19] = "0b00111111000100000101110100010000";
        ram[20] = "0b00111111000101110010111011110001";
        ram[21] = "0b00111111000101100010001110001110";
        ram[22] = "0b00111111000101000000100011011001";
        ram[23] = "0b00111111000101101010100100111111";
        ram[24] = "0b00111111000101011001110010001101";
        ram[25] = "0b00111111000011111101011000001111";
        ram[26] = "0b00111111000010101001011010010010";
        ram[27] = "0b00111111000010111010001101000100";
        ram[28] = "0b00111111000110101101110000001010";
        ram[29] = "0b00111111000010100000111110010001";
        ram[30] = "0b00111111000010010000001011011110";
        ram[31] = "0b00111111000010000111110100101100";


SC_METHOD(prc_write_0);
  sensitive<<clk.pos();
   }


void prc_write_0()
{
    if (ce0.read() == sc_dt::Log_1) 
    {
            if(address0.read().is_01() && address0.read().to_uint()<AddressRange)
              q0 = ram[address0.read().to_uint()];
            else
              q0 = sc_lv<DataWidth>();
    }
}


}; //endmodule


SC_MODULE(fw_binned_binw_lut) {


static const unsigned DataWidth = 32;
static const unsigned AddressRange = 32;
static const unsigned AddressWidth = 5;

sc_core::sc_in <sc_lv<AddressWidth> > address0;
sc_core::sc_in<sc_logic> ce0;
sc_core::sc_out <sc_lv<DataWidth> > q0;
sc_core::sc_in<sc_logic> reset;
sc_core::sc_in<bool> clk;


fw_binned_binw_lut_ram* meminst;


SC_CTOR(fw_binned_binw_lut) {
meminst = new fw_binned_binw_lut_ram("fw_binned_binw_lut_ram");
meminst->address0(address0);
meminst->ce0(ce0);
meminst->q0(q0);

meminst->reset(reset);
meminst->clk(clk);
}
~fw_binned_binw_lut() {
    delete meminst;
}


};//endmodule
#endif
