// ==============================================================
// Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC v2019.2.1 (64-bit)
// Copyright 1986-2019 Xilinx, Inc. All Rights Reserved.
// ==============================================================
#ifndef __fw_binned_dlog_64ocq__HH__
#define __fw_binned_dlog_64ocq__HH__
#include "ACMP_dlog.h"
#include <systemc>

template<
    int ID,
    int NUM_STAGE,
    int din0_WIDTH,
    int din1_WIDTH,
    int dout_WIDTH>
SC_MODULE(fw_binned_dlog_64ocq) {
    sc_core::sc_in_clk clk;
    sc_core::sc_in<sc_dt::sc_logic> reset;
    sc_core::sc_in<sc_dt::sc_logic> ce;
    sc_core::sc_in< sc_dt::sc_lv<din0_WIDTH> >   din0;
    sc_core::sc_in< sc_dt::sc_lv<din1_WIDTH> >   din1;
    sc_core::sc_out< sc_dt::sc_lv<dout_WIDTH> >   dout;



    ACMP_dlog<ID, 7, din0_WIDTH, din1_WIDTH, dout_WIDTH> ACMP_dlog_U;

    SC_CTOR(fw_binned_dlog_64ocq):  ACMP_dlog_U ("ACMP_dlog_U") {
        ACMP_dlog_U.clk(clk);
        ACMP_dlog_U.reset(reset);
        ACMP_dlog_U.ce(ce);
        ACMP_dlog_U.din0(din0);
        ACMP_dlog_U.din1(din1);
        ACMP_dlog_U.dout(dout);

    }

};

#endif //
