-- ==============================================================
-- Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC v2019.2.1 (64-bit)
-- Copyright 1986-2019 Xilinx, Inc. All Rights Reserved.
-- ==============================================================
library ieee; 
use ieee.std_logic_1164.all; 
use ieee.std_logic_unsigned.all;

entity fw_binned_binw_lut_rom is 
    generic(
             DWIDTH     : integer := 32; 
             AWIDTH     : integer := 5; 
             MEM_SIZE    : integer := 32
    ); 
    port (
          addr0      : in std_logic_vector(AWIDTH-1 downto 0); 
          ce0       : in std_logic; 
          q0         : out std_logic_vector(DWIDTH-1 downto 0);
          clk       : in std_logic
    ); 
end entity; 


architecture rtl of fw_binned_binw_lut_rom is 

signal addr0_tmp : std_logic_vector(AWIDTH-1 downto 0); 
type mem_array is array (0 to MEM_SIZE-1) of std_logic_vector (DWIDTH-1 downto 0); 
signal mem : mem_array := (
    0 => "00111111000101001000111110010111", 
    1 => "00111111000100011110111110110111", 
    2 => "00111111000110110110001010100110", 
    3 => "00111111000101010001010111110000", 
    4 => "00111111000100010110100111000010", 
    5 => "00111111000110011100111101010111", 
    6 => "00111111000101001000111111011010", 
    7 => "00111111000100101111110000100110", 
    8 => "00111111000110011100111101010111", 
    9 => "00111111000101001000111111011010", 
    10 => "00111111000101000000100011011001", 
    11 => "00111111000110010100100110100101", 
    12 => "00111111000101010001010110001100", 
    13 => "00111111000100111000001100100111", 
    14 => "00111111000110000011101110100011", 
    15 to 16=> "00111111000101001000111111011010", 
    17 => "00111111001000100011011000111011", 
    18 => "00111111000100010110100001110011", 
    19 => "00111111000100000101110100010000", 
    20 => "00111111000101110010111011110001", 
    21 => "00111111000101100010001110001110", 
    22 => "00111111000101000000100011011001", 
    23 => "00111111000101101010100100111111", 
    24 => "00111111000101011001110010001101", 
    25 => "00111111000011111101011000001111", 
    26 => "00111111000010101001011010010010", 
    27 => "00111111000010111010001101000100", 
    28 => "00111111000110101101110000001010", 
    29 => "00111111000010100000111110010001", 
    30 => "00111111000010010000001011011110", 
    31 => "00111111000010000111110100101100" );


begin 


memory_access_guard_0: process (addr0) 
begin
      addr0_tmp <= addr0;
--synthesis translate_off
      if (CONV_INTEGER(addr0) > mem_size-1) then
           addr0_tmp <= (others => '0');
      else 
           addr0_tmp <= addr0;
      end if;
--synthesis translate_on
end process;

p_rom_access: process (clk)  
begin 
    if (clk'event and clk = '1') then
        if (ce0 = '1') then 
            q0 <= mem(CONV_INTEGER(addr0_tmp)); 
        end if;
    end if;
end process;

end rtl;

Library IEEE;
use IEEE.std_logic_1164.all;

entity fw_binned_binw_lut is
    generic (
        DataWidth : INTEGER := 32;
        AddressRange : INTEGER := 32;
        AddressWidth : INTEGER := 5);
    port (
        reset : IN STD_LOGIC;
        clk : IN STD_LOGIC;
        address0 : IN STD_LOGIC_VECTOR(AddressWidth - 1 DOWNTO 0);
        ce0 : IN STD_LOGIC;
        q0 : OUT STD_LOGIC_VECTOR(DataWidth - 1 DOWNTO 0));
end entity;

architecture arch of fw_binned_binw_lut is
    component fw_binned_binw_lut_rom is
        port (
            clk : IN STD_LOGIC;
            addr0 : IN STD_LOGIC_VECTOR;
            ce0 : IN STD_LOGIC;
            q0 : OUT STD_LOGIC_VECTOR);
    end component;



begin
    fw_binned_binw_lut_rom_U :  component fw_binned_binw_lut_rom
    port map (
        clk => clk,
        addr0 => address0,
        ce0 => ce0,
        q0 => q0);

end architecture;


