// Define constants
//const int my_precision=4095; // 4 degit match for inte2......
//const int my_precision=1024; // 3dig for integ2
//const int my_precision=512;
//const int my_precision=256;
//const int my_precision=64;  // over?
const int my_precision=32; //maybe enough for integral1...
//const int my_precision=16; // NODIF IN 6 DIG for integ1
//const int my_precision=8; // 3 DIGIT for integ1
//const int my_precision=4; //bad
const double precision = 1e-7; // a parameter for numerical integration, reduce to speed up calculation

// Fit constants for protons in H2O
const double mp      = 1.007276466621; //in u
const double alpha_P = 0.02543;
const double p_P     = 1.742;
const double beta    = 0.0012;
const double gamma_H2O = 0.6;
const double epsilon = 0.;
const double rho     = 1.0e-3;
const double S       = 10000;

// Fit constants for helium/carbon in H2O
const double alpha_He = 0.00228;
const double p_He = 1.742;
const double alpha_C = 0.000222;
const double p_C = 1.625;

double alpha = alpha_P;
double p = p_P;

TH1D *hd ;

const int nbin=32;
double bins[nbin+1]={ 0,  2.90158,  5.7519,  8.78677,  11.6986,  14.5387,  17.5428,  20.4444,
		      23.3152,  26.3193,  29.2209,  32.1122,  35.1061,  38.0179,  40.899,  43.8723,
		      46.7739,  49.6755,  52.8437, 55.6837,  58.5033,  61.4561,  64.3885,  67.2798,
		      70.2224,  73.1445,  75.9538,  78.6606,  81.3879,  84.4125,  87.109,  89.785,
		      92.4508};


//This returns the actual quenched Bragg fit curve
struct QuenchedBragg {
  QuenchedBragg() {}
      
  double operator() (double* z, double* par) {
    double R0      = par[0];
    double sigma   = par[1];
    double phi0    = par[2];
    double xOffset = par[3];
    double birks   = par[4];

    if (R0<=0.) return 0.;
    if (sigma<=0.) return 0.;
    if (phi0<=0.) return 0.;
    if (xOffset<0.) return 0.;
    if (birks<=0.) return 0.;
    if (R0 != R0) return 0.; //Check if R0 is nan
    if (z[0] != z[0]) return 0.; //Check if z is nan
    z[0] = z[0] + xOffset; //add xOffset

    if (z[0] < 0) return 0.;

    // Some numerical parameters. They are optimized in such a way that the fit returns accurate results without throwing segfaults or unreached precision errors
    double zDef = 5.*sigma; //This constant determines in which area the integrator of fInt1 and fInt2 gonna be defined and integrated, see definition of a and b
    double a = min(z[0]-zDef,(1.-precision-1e-3)*R0); // integration start. Subtract constant to make sure a is smaller than b
    double b = min(z[0]+zDef,(1.-precision)*R0); // integration end
    
    // HH Bo integral 1 part HH// ---------------------------------------------------------------------------------------------------------
    double width=(b-a)/my_precision;
    double xx=a+width/2.;
    double integral1=0;
    for(int i=0; i<my_precision; i++){
      double preFactor = (1.+beta*(R0-xx))/(1+beta*R0);
      double foldingTerm = 1./(2.507*sigma)*exp(-(z[0]-xx)*(z[0]-xx)/(2*sigma*sigma));    
      double tdLdz=1./(0.2117*pow(R0-xx,0.425)+birks);
      double val = preFactor * tdLdz * foldingTerm;
      integral1+=val*width;
      xx+=width;
    }
    // HH Bo integral 2 part HH// ---------------------------------------------------------------------------------------------------------
    double LofZ = 0;
    double myLofZ=0;
    if(z[0]<(1-precision)*R0){
      double width=((1-precision)*R0-z[0])/my_precision;
      double xx=z[0]+width/2.;
      for(int i=0; i<my_precision; i++){
	double val  = 1./(0.2117*pow(R0-xx,0.425)+birks);
	myLofZ+=val*width;
	xx+=width;
      }
    }
    double pF = gamma_H2O*beta/(1+beta*R0);
    double integral2 = pF * myLofZ;
    // HH Eo integral 2 part HH// ---------------------------------------------------------------------------------------------------------
    double preFactor = S*phi0/rho;           // Put all parts together and add scaling factor
    double integral = integral1 + integral2; // Put all parts together and add scaling factor
    // Combine prefactor and integral of all parts
    double val = preFactor*integral;
    return val;
  }
};





// my fit  func
void QuenchedBraggFitFunc(int &npar, double *gin, double &f, double *par, int iflag){
  double R0      = par[0];
  double sigma   = par[1];
  double phi0    = par[2];
  double xOffset = 0;
  double birks   = par[3];
  Double_t logL=0;
  double rx=0;
  double highL=35767;
  if (R0<=0.) f=highL;
  if (sigma<=0.) f=highL;
  if (phi0<=0.) f=highL;
  if (xOffset<0.) f=highL;
  if (birks<=0.) f=highL;
  if (R0 != R0) f=highL; //Check if R0 is nan
  if (rx != rx) f=highL; //Check if z is nan
  rx = rx + xOffset; //add xOffset
  if (rx < 0) f=highL;


  for(int ibin=1; ibin<nbin+1; ibin++){
     double logP = 0;
    //HH observed HH//
    double ob=hd->GetBinContent(ibin);
    double obe=hd->GetBinError(ibin);
    rx=hd->GetBinCenter(ibin);
    //HH expected HH//
    double zDef = 5.*sigma; //This constant determines in which area the integrator of fInt1 and fInt2 gonna be defined and integrated, see definition of a and b
    double a = min(rx-zDef,(1.-precision-1e-3)*R0); // integration start. Subtract constant to make sure a is smaller than b
    double b = min(rx+zDef,(1.-precision)*R0); // integration end
    // HH Bo integral 1 part HH// ---------------------------------------------------------------------------------------------------------
    double width=(b-a)/my_precision;
    double xx=a+width/2.;
    double integral1=0;
    for(int i=0; i<my_precision; i++){
      double preFactor = (1.+beta*(R0-xx))/(1+beta*R0);
      double foldingTerm = 1./(2.507*sigma)*exp(-(rx-xx)*(rx-xx)/(2*sigma*sigma));    
      double tdLdz=1./(0.2117*pow(R0-xx,0.425)+birks);
      double val = preFactor * tdLdz * foldingTerm;
      integral1+=val*width;
      xx+=width;
    }
    // HH Bo integral 2 part HH// ---------------------------------------------------------------------------------------------------------
    double LofZ = 0;
    double myLofZ=0;
    if(rx<(1-precision)*R0){
      double width=((1-precision)*R0-rx)/my_precision;
      double xx=rx+width/2.;
      for(int i=0; i<my_precision; i++){
	double val  = 1./(0.2117*pow(R0-xx,0.425)+birks);
	myLofZ+=val*width;
	xx+=width;
      }
    }
    double pF = gamma_H2O*beta/(1+beta*R0);
    double integral2 = pF * myLofZ;
    // Combine prefactor and integral of all parts
    double preFactor = S*phi0/rho;           // Put all parts together and add scaling factor
    double integral = integral1 + integral2; // Put all parts together and add scaling factor
    double ex = preFactor*integral;
    //HH -2 Log gaussian likelihood calculatio to estimate mini L position for minimizer
    if(ex>0){
      logP=(ob-ex)*(ob-ex)/(sigma*sigma)+2*log(sigma*2.507);
    }
    logL+=logP;
  } // end loop for bins for minL
  f=logL;
}
