// Define constants
//const int my_precision=4095; // 4 degit match for inte2......
const int my_precision=1024;
//const int my_precision=512;
//const int my_precision=256;
//const int my_precision=64;  // over?
//const int my_precision=32; //maybe enough for integral1...
//const int my_precision=16; // NODIF IN 6 DIG
//const int my_precision=8; // 3 DIGIT
//const int my_precision=4; //bad
const double precision = 1e-7; // a parameter for numerical integration, reduce to speed up calculation
const double pi = 3.14159265358979323846;

// Fit constants for protons in H2O
const double mp      = 1.007276466621; //in u
const double alpha_P = 0.02543;
const double p_P     = 1.742;
const double beta    = 0.0012;
const double gamma_H2O = 0.6;
const double epsilon = 0.;
const double rho     = 1.0e-3;
const double S       = 10000;

// Fit constants for helium/carbon in H2O
const double alpha_He = 0.00228;
const double p_He = 1.742;
const double alpha_C = 0.000222;
const double p_C = 1.625;

double alpha = alpha_P;
double p = p_P;

//get dL/dz as TF1 without normalisation
double dLdz(double *zpp, double *par) {
  double R0    = par[0];
  double birk  = par[1];
  double val  = 1./(0.2117*pow(R0-zpp[0],0.425)+birk);
  return val;
}

//get dL/dz without normalisation
double dLdz(double zp, double R0, double birk) {
  double val  = 1./(0.2117*pow(R0-zp,0.425)+birk);
  return val;
}

// Return term which includes dL/dz
double dLTerm(double *zp, double *par) {
  double R0     = par[0];
  double sigma  = par[1];
  double birk   = par[2];
  double z      = par[3];
  double preFactor = (1.+beta*(R0-zp[0]))/(1+beta*R0);
  double foldingTerm = 1./(2.507*sigma)*exp(-(z-zp[0])*(z-zp[0])/(2*sigma*sigma));    
  //    double val = preFactor * dLdz(zp[0],R0,birk) * foldingTerm;
  double tdLdz=1./(0.2117*pow(R0-zp[0],0.425)+birk);
  double val = preFactor * tdLdz * foldingTerm;
  return val;
}

// Return term which includes L(z)
struct LTerm {
  TF1* fdLdz = nullptr;

LTerm(TF1 &f) : fdLdz(&f) {}

  double operator() (double *zp, double *par) {
    double R0   = par[0];
    double birk = par[1];

    fdLdz->SetParameters(R0,birk);
    double LofZ = 0;
    //    if(zp[0]<(1-precision)*R0) LofZ = fdLdz->Integral(zp[0],(1-precision)*R0,precision);
    if(zp[0]<(1-precision)*R0){
      LofZ = fdLdz->Integral(zp[0],(1-precision)*R0,precision);

      double width=((1-precision)*R0-zp[0])/my_precision;
      //      cout<<"detail ab= "<<zp[0]<<"  "<<(1-precision)*R0<<"  width = "<<width<<endl;
      double xx=zp[0]+width/2.;
      double myLofZ=0;
      for(int i=0; i<my_precision; i++){
	double val  = 1./(0.2117*pow(R0-xx,0.425)+birk);
	//	double dEdx_inv = p*pow(alpha,1./p)*pow((R0-xx),(1.-1./p));
	//	double val = 1./(dEdx_inv + birk);
	myLofZ+=val*width;
	//	cout<<xx<<endl;
	xx+=width;
      }
      cout<<"my check LofZ="<<LofZ<<"   myLofZ="<<myLofZ<<endl;
      //      LofZ=myLofZ;
    }

    
    double preFactor = gamma_H2O*beta/(1+beta*R0);
    double val = preFactor * LofZ;
    //    cout<<"val="<<val;
    return val;
  }
};

//This returns the actual quenched Bragg fit curve
struct QuenchedBragg {
    
  std::unique_ptr<TF1> fdLTerm;
  std::unique_ptr<TF1> fLTerm;
  std::unique_ptr<TF1> fdLdz;
    
  QuenchedBragg() {
    fdLdz   = std::unique_ptr<TF1>(new TF1("fdLdz",dLdz, 0., 1., 2));
    // fdLdz   = std::unique_ptr<TF1>(new TF1("fdLdz","1./(0.2117*pow([0]-x,0.425)+[2])", 0., 1.));      
    fdLTerm = std::unique_ptr<TF1>(new TF1("fdLTerm",dLTerm, 0., 1., 4));
    fLTerm  = std::unique_ptr<TF1>(new TF1("fLTerm",LTerm(*fdLdz),0., 1., 2));
  }
      
  double operator() (double* z, double* par) {
    double R0      = par[0];
    double sigma   = par[1];
    double phi0    = par[2];
    double xOffset = par[3];
    double birks   = par[4];

    if (R0<=0.) return 0.;
    if (sigma<=0.) return 0.;
    if (phi0<=0.) return 0.;
    if (xOffset<0.) return 0.;
    if (birks<=0.) return 0.;
    if (R0 != R0) return 0.; //Check if R0 is nan
    if (z[0] != z[0]) return 0.; //Check if z is nan
    z[0] = z[0] + xOffset; //add xOffset
    if (z[0] < 0) return 0.;

    // Some numerical parameters. They are optimized in such a way that the fit returns accurate results without throwing segfaults or unreached precision errors
    double zDef = 5.*sigma; //This constant determines in which area the integrator of fInt1 and fInt2 gonna be defined and integrated, see definition of a and b
    double a = min(z[0]-zDef,(1.-precision-1e-3)*R0); // integration start. Subtract constant to make sure a is smaller than b
    double b = min(z[0]+zDef,(1.-precision)*R0); // integration end
    
    //    fdLTerm->SetParameters(R0,sigma,birks,z[0]); 
    //    double integral1 = fdLTerm->Integral(a,b,precision); 
    // HH Bo integral 1 part HH// ---------------------------------------------------------------------------------------------------------
    double width=(b-a)/my_precision;
    double xx=a+width/2.;
    double my_integral1=0;
    for(int i=0; i<my_precision; i++){
      double preFactor = (1.+beta*(R0-xx))/(1+beta*R0);
      double foldingTerm = 1./(2.507*sigma)*exp(-(z[0]-xx)*(z[0]-xx)/(2*sigma*sigma));    
      double tdLdz=1./(0.2117*pow(R0-xx,0.425)+birks);
      double val = preFactor * tdLdz * foldingTerm;
      my_integral1+=val*width;
      xx+=width;
    }
    //	cout<<"My special check  integral1 = "<<integral1<<"   my int1 = "<<my_integral1<<"   ab="<<a<<" "<<b<<"  width="<<width<<endl;
    double integral1 = my_integral1;
    // HH Eo integral 1 part HH// ---------------------------------------------------------------------------------------------------------



    fLTerm->SetParameters(R0,birks);
    //    double integral2 = fLTerm->Eval(z[0]); // approximation without folding
    // HH Bo integral 2 part HH// ---------------------------------------------------------------------------------------------------------
    double LofZ = 0;
    double myLofZ=0;
    if(z[0]<(1-precision)*R0){
      double width=((1-precision)*R0-z[0])/my_precision;
      //      cout<<"detail ab= "<<z[0]<<"  "<<(1-precision)*R0<<"  width = "<<width<<endl;
      double xx=z[0]+width/2.;

      for(int i=0; i<my_precision; i++){
	double val  = 1./(0.2117*pow(R0-xx,0.425)+birks);
	myLofZ+=val*width;
	xx+=width;
      }
      //      cout<<"my check LofZ="<<LofZ<<"   myLofZ="<<myLofZ<<endl;
    }

    
    double pF = gamma_H2O*beta/(1+beta*R0);
    double my_integral2 = pF * myLofZ;
    //    cout<<"My special check  integral2 = "<<integral2<<"   my int2 = "<<my_integral2<<endl;
    double integral2=pF*myLofZ;
    // HH Eo integral 2 part HH// ---------------------------------------------------------------------------------------------------------

    double preFactor = S*phi0/rho;           // Put all parts together and add scaling factor
    double integral = integral1 + integral2; // Put all parts together and add scaling factor
    // Combine prefactor and integral of all parts
    double val = preFactor*integral;
    return val;
  }
};

