// Define constants
//const int my_precision=4095; // 4 degit match for inte2......
//const int my_precision=1024; // 3dig for integ2
//const int my_precision=512;
//const int my_precision=256;
//const int my_precision=64;  // over?
//const int my_precision=32; //maybe enough for integral1...
const int my_precision=16; // NODIF IN 6 DIG for integ1 //def
//const int my_precision=8; // 3 DIGIT for integ1
//const int my_precision=4; //bad

// number of point to estimate average value in a bin (like "I" option for TF1's fit).
//const int nintegbin=64; 
const int nintegbin=4; // def
//const int nintegbin=2; 


/* for compare original also
const double precision = 1e-7; // a parameter for numerical integration, reduce to speed up calculation
// Fit constants for protons in H2O
const double mp      = 1.007276466621; //in u
const double alpha_P = 0.02543;
const double p_P     = 1.742;
const double beta    = 0.0012;
const double gamma_H2O = 0.6;
const double epsilon = 0.;
const double rho     = 1.0e-3;
const double S       = 10000;
// Fit constants for helium/carbon in H2O
const double alpha_He = 0.00228;
const double p_He = 1.742;
const double alpha_C = 0.000222;
const double p_C = 1.625;
double alpha = alpha_P;
double p = p_P;
*/

TH1D *hd ;
const int nbin=32;
double bins[nbin+1]={ 0,  2.90158,  5.7519,  8.78677,  11.6986,  14.5387,  17.5428,  20.4444,
		      23.3152,  26.3193,  29.2209,  32.1122,  35.1061,  38.0179,  40.899,  43.8723,
		      46.7739,  49.6755,  52.8437, 55.6837,  58.5033,  61.4561,  64.3885,  67.2798,
		      70.2224,  73.1445,  75.9538,  78.6606,  81.3879,  84.4125,  87.109,  89.785,
		      92.4508};


// my fit  func
void QuenchedBraggFitFunc(int &npar, double *gin, double &f, double *par, int iflag){
  int debug=0;
  double R0      = par[0];
  double sigma   = par[1];
  double phi0    = par[2];
  double xOffset = 0;
  double birks   = par[3];
  Double_t logL=0;
  double rx=0;
  double highL=35767;
  if (R0<=0.) f=highL;
  if (sigma<=0.) f=highL;
  if (phi0<=0.) f=highL;
  if (xOffset<0.) f=highL;
  if (birks<=0.) f=highL;
  if (R0 != R0) f=highL; //Check if R0 is nan
  if (rx != rx) f=highL; //Check if z is nan
  rx = rx + xOffset; //add xOffset
  if (rx < 0) f=highL;

  for(int ibin=1; ibin<nbin+1; ibin++){
    double logP = 0;
    //HH observed HH//
    double ob=hd->GetBinContent(ibin);
    double obe=hd->GetBinError(ibin);
    //HH expected HH//
    double sum_integ1=0, sum_integ2=0;
    double bin_width=bins[ibin]-bins[ibin-1];
    double bin_step = bin_width/(nintegbin+1);
    //    cout<<"bin_step = "<<bin_step<<endl;
    for(int integbin=0; integbin<nintegbin; integbin++){
      rx=bins[ibin-1]+bin_step*(integbin+1);
      if(debug)cout<<"ibin="<<ibin<<", rx="<<rx;
      double zDef = 5.*sigma; //This constant determines in which area the integrator of fInt1 and fInt2 gonna be defined and integrated, see definition of a and b
      double a = min(rx-zDef,(1.-precision-1e-3)*R0); // integration start. Subtract constant to make sure a is smaller than b
      double b = min(rx+zDef,(1.-precision)*R0); // integration end
      // HH Bo integral  part HH// ---------------------------------------------------------------------------------------------------------
      double integral1=0;//integ 1 par
      double width1=(b-a)/my_precision; 
      double xx1=a+width1/2.;
      double integral2=0;//integ 2 par
      double pF2 = gamma_H2O*beta/(1+beta*R0);
      double LofZ = 0;  
      double myLofZ=0;
      double width2=((1-precision)*R0-rx)/my_precision;
      double xx2=rx+width2/2.;
      for(int i=0; i<my_precision; i++){
	// integ 1
	double pF1 = (1.+beta*(R0-xx1))/(1+beta*R0);
	double foldingTerm = 1./(2.507*sigma)*exp(-(rx-xx1)*(rx-xx1)/(2*sigma*sigma));
	double tdLdz=1./(0.2117*pow(R0-xx1,0.425)+birks);
	double val1 = pF1 * tdLdz * foldingTerm;
	integral1+=val1*width1;
	xx1+=width1;
	// integ 2
	if(rx<(1-precision)*R0){
	  double val2  = 1./(0.2117*pow(R0-xx2,0.425)+birks);
	  myLofZ+=val2*width2;
	  xx2+=width2;
	}
      }
      integral2 = pF2 * myLofZ;
      if(debug)cout<<"   integ1 2 ="<<integral1<<" "<<integral2<<"   tot="<<(integral1+integral2)*(S*phi0/rho)<<endl;
      sum_integ1+=integral1;
      sum_integ2+=integral2;
    }

    double integral = (sum_integ1 + sum_integ2)/nintegbin; // Put all parts together and add scaling factor    
    // Combine prefactor and integral of all parts
    double preFactor = S*phi0/rho;           // Put all parts together and add scaling factor
    double ex = preFactor*integral;
    if(debug)    cout<<ibin<<"  final ex="<<ex<<",   ob="<<ob<<endl;
    //HH -2 Log gaussian likelihood calculatio to estimate mini L position for minimizer
    if(ex>0){
      logP=(ob-ex)*(ob-ex)/(obe*obe)+2*log(obe*2.507);
    }
    logL+=logP;
    //   cout<<fixed;
    //   cout<<setprecision(3)<<setfill('0')<<setw(2)<<ibin<<" p="<<setw(6)<<logP<<"  ex="<<setw(6)<<ex<<", ob="<<setw(6)<<ob<<", obe="<<setw(6)<<obe<<endl;;
  } // end loop for bins for minL
  f=logL;
  //  cout<<"f="<<f<<endl;
}
