--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 


library IEEE;
use IEEE.STD_LOGIC_1164.all;

package crc_gen_pkg is

  
--  type <new_type> is
--    record
--        <type_name>        : std_logic_vector( 7 downto 0);
--        <type_name>        : std_logic;
--    end record;

-- Declare constants

--  constant <constant_name>		: time := <time_unit> ns;
  constant CRC_INIT_VAL : std_logic_vector (7 downto 0) := x"FF";
 
-- Declare functions and procedure

  function crc_8_gen  (data : std_logic_vector (7 downto 0);
                       crc  : std_logic_vector (7 downto 0)
                       ) return std_logic_vector;
--  procedure <procedure_name>	(<type_declaration> <constant_name>	: in <type_declaration>);
  
  function find_one (type_vector : std_logic_vector) return integer ;
  function find_one_2 (type_vector : std_logic_vector) return integer ;   

end crc_gen_pkg;


package body crc_gen_pkg is
  
-------------------------------------------------------------------------------
-- CRC function for data(7:0)
--   lfsr(7:0)=1+x^1+x^2+x^8;
-------------------------------------------------------------------------------

-- Example 1
  function find_one (type_vector : std_logic_vector) return integer is
    variable i, index : integer;
   begin
      for i in 0 to ((type_vector'length)- 1) loop
         if type_vector(i) = '1' then
            index := i;
            exit;
         end if;
      end loop;
   return index;
                
   end find_one;
  
  function find_one_2 (type_vector : std_logic_vector) return integer is
    variable i, index_2 : integer := 0;
    variable index : integer := -1;
   begin
        for i in 0 to (type_vector'length - 1)  loop
            if type_vector (i) = '1' then
               index := i;
            end if;
       end loop;
       return index;   
  end find_one_2;
  
  function crc_8_gen  (data : std_logic_vector (7 downto 0);
                       crc  : std_logic_vector (7 downto 0)
                       ) return std_logic_vector is
    
    variable D: std_logic_vector(7 downto 0);
    variable C: std_logic_vector(7 downto 0);
    variable NewCRC: std_logic_vector(7 downto 0);
  
  begin
    
    D := Data;
    C := CRC;
    
    NewCRC(0) := D(0) xor D(6) xor D(7) xor C(0) xor C(6) xor C(7);
    NewCRC(1) := D(0) xor D(1) xor D(6) xor C(0) xor C(1) xor C(6);
    NewCRC(2) := D(0) xor D(1) xor D(2) xor D(6) xor C(0) xor C(1) xor C(2) xor C(6);
    NewCRC(3) := D(1) xor D(2) xor D(3) xor D(7) xor C(1) xor C(2) xor C(3) xor C(7);
    NewCRC(4) := D(2) xor D(3) xor D(4) xor C(2) xor C(3) xor C(4);
    NewCRC(5) := D(3) xor D(4) xor D(5) xor C(3) xor C(4) xor C(5);
    NewCRC(6) := D(4) xor D(5) xor D(6) xor C(4) xor C(5) xor C(6);
    NewCRC(7) := D(5) xor D(6) xor D(7) xor C(5) xor C(6) xor C(7);
        
    return NewCRC; 
  end crc_8_gen;


---- Example 2
--  function <function_name>  (signal <signal_name> : in <type_declaration>;
--                         signal <signal_name>   : in <type_declaration>  ) return <type_declaration> is
--  begin
--    if (<signal_name> = '1') then
--      return <signal_name>;
--    else
--      return 'Z';
--    end if;
--  end <function_name>;
--
---- Procedure Example
--  procedure <procedure_name>  (<type_declaration> <constant_name>  : in <type_declaration>) is
--    
--  begin
--    
--  end <procedure_name>;
 
end crc_gen_pkg;



