----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    12:05:53 10/01/2010 
-- Design Name: 
-- Module Name:    telegrm_receive - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
library UNISIM;
use UNISIM.VComponents.all;

use work.crc_gen_pkg.all;

entity telegrm_receive is
    Port ( reset : in  STD_LOGIC;
           clkout27 : out  STD_LOGIC;
           data_in_diff : in  STD_LOGIC_VECTOR (1 downto 0);
           clock_in_diff  : in  STD_LOGIC_VECTOR (1 downto 0);
           train_no_out : out std_logic_vector (31 downto 0);
           bunch_pattern_out : out std_logic_vector (31 downto 0);
           start_train_flag : out std_logic;
           end_train_flag : out std_logic;
           daq_ready_flag : out std_logic;
           write_flag : out std_logic_vector (4 downto 0);
           control_2 : inout std_logic_vector (35 downto 0); --- For the chipscope cores -- Can be commented if not used
           button_2_pushed : in std_logic -- for debug -- can be commented --
           
           );
end telegrm_receive;

architecture Behavioral of telegrm_receive is

function find_one_2 (type_vector : std_logic_vector) return integer is
    variable i, index_2 : integer := 0;
    variable index : integer := -1;
   begin
        for i in 0 to (type_vector'length - 1)  loop
            if type_vector (i) = '1' then
               index := i;
            end if;
       end loop;
       return index;   
end find_one_2;

component ila_second
  PORT (
    CONTROL : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0);
    CLK : IN STD_LOGIC;
    TRIG0 : IN STD_LOGIC_VECTOR(83 DOWNTO 0));
end component;

signal clock_in   : std_logic;
signal rcv_clk    : std_logic;
signal rcv_clkin  : std_logic;
signal data_in    : std_logic;
signal RCV_CLKDIV : std_logic;
signal q1    : std_logic;
signal q2    : std_logic;
signal q3    : std_logic;
signal q4    : std_logic;
signal q5    : std_logic;
signal q6    : std_logic;
signal q1_d  : std_logic;
signal q2_d  : std_logic;
signal q3_d  : std_logic;
signal q4_d  : std_logic;

signal trig0 : std_logic_vector (83 downto 0);

type state_type is (IDLE, run_1, run_2, run_3, run_4, run_5, crc_check);
signal bs_state : state_type; 

type state_type_2 is (first,second,third,fourth);
signal state : state_type_2;

signal BITSLIP : std_logic;

signal Q1_clk, Q2_clk, Q3_clk, Q4_clk, Q5_clk, Q6_clk : std_logic;
signal button_2_pushed_d : std_logic;
signal test_word, test_word_d : std_logic_vector (3 downto 0);
signal locked : std_logic;

signal test_ch_1 : std_logic_vector (1 downto 0);
signal test_ch_2 : std_logic_vector (2 downto 0);
signal data_flag : std_logic;

signal train_no : std_logic_vector (31 downto 0);
signal bunch_pattern : std_logic_vector (31 downto 0);
signal data_counter : integer range 0 to 7;

signal crc_init : std_logic_vector (7 downto 0) := x"FF";
signal header   : std_logic_vector (7 downto 0);
signal crc_ok   : std_logic;
signal write_flag_t : std_logic_vector (4 downto 0);

begin

--IDELAYCTRL_inst : IDELAYCTRL
--
--port map (
--RDY => ready, 
--REFCLK => clk200, 
--RST => RST -- 1-bit Resets the IDELAYCTRL circuitry. The RST signal is an active-high asynchronous
---- reset. To reset the IDELAYCTRL, assert it High for at least 50 ns.
--);
  
  DATA_IN_BUF : IBUFDS
      PORT MAP (
         O => data_in,
         I => data_in_diff(0),
         IB => data_in_diff(1));
   
   CLOCK_IN_BUF : IBUFDS
      PORT MAP (
         O => clock_in,
         I => clock_in_diff(0),
         IB => clock_in_diff(1));   
   
   
   
   RX_CLK_BUFIO : BUFIO 
      PORT MAP (
         O => rcv_clk,
         I => clock_in);   
   
   
   --CLOCK BUFFER/DIVIDER FOR PARALLEL SIDE CLOCK

   RX_CLK_BUFR : BUFR 
      GENERIC MAP( 
         BUFR_DIVIDE => "4" )
      PORT MAP (
         O => RCV_CLKDIV,
         CE => '1',
         CLR => '0',
         I => clock_in);   


-- Not needed can be commented -- For possible future development --

   ISERDES_NODELAY_inst_clk : ISERDES_NODELAY
      generic map (
         BITSLIP_ENABLE => TRUE, 
         DATA_RATE => "SDR", 
         DATA_WIDTH => 4, 
         INTERFACE_TYPE => "NETWORKING", 
         NUM_CE => 1, 
         SERDES_MODE => "MASTER") 
      port map (
         Q1 => Q1_clk, 
         Q2 => Q2_clk, 
         Q3 => Q3_clk, 
         Q4 => Q4_clk, 
         Q5 => Q5_clk, 
         Q6 => Q6_clk, 
         SHIFTOUT1 => open, -- 1-bit cascade Master/Slave output
         SHIFTOUT2 => open, -- 1-bit cascade Master/Slave output
         BITSLIP => BITSLIP, -- 1-bit Bitslip enable input
         CE1 => '1', -- 1-bit clock enable input
         CE2 => '0', -- 1-bit clock enable input
         CLK => RCV_CLK, -- 1-bit master clock input
         CLKB => '0', -- 1-bit secondary clock input for DATA_RATE=DDR
         CLKDIV => RCV_CLKDIV, -- 1-bit divided clock input
         D => clock_in, -- 1-bit data input, connects to IODELAY or input buffer
         OCLK => '0', -- 1-bit fast output clock input
         RST => reset, -- 1-bit asynchronous reset input
         SHIFTIN1 => '0', -- 1-bit cascade Master/Slave input
         SHIFTIN2 => '0' -- 1-bit cascade Master/Slave input
      );

      ISERDES_NODELAY_inst : ISERDES_NODELAY
      generic map (
         BITSLIP_ENABLE => TRUE, 
         DATA_RATE => "SDR", 
         DATA_WIDTH => 4, 
         INTERFACE_TYPE => "NETWORKING", 
         NUM_CE => 1, 
         SERDES_MODE => "MASTER") 
      port map (
         Q1 => Q1, 
         Q2 => Q2, 
         Q3 => Q3, 
         Q4 => Q4, 
         Q5 => Q5, 
         Q6 => Q6, 
         SHIFTOUT1 => open, -- 1-bit cascade Master/Slave output
         SHIFTOUT2 => open, -- 1-bit cascade Master/Slave output
         BITSLIP => BITSLIP, -- 1-bit Bitslip enable input
         CE1 => '1', -- 1-bit clock enable input
         CE2 => '0', -- 1-bit clock enable input
         CLK => RCV_CLK, -- 1-bit master clock input
         CLKB => '0', -- 1-bit secondary clock input for DATA_RATE=DDR
         CLKDIV => RCV_CLKDIV, -- 1-bit divided clock input
         D => data_in, -- 1-bit data input, connects to IODELAY or input buffer
         OCLK => '0', -- 1-bit fast output clock input
         RST => reset, -- 1-bit asynchronous reset input
         SHIFTIN1 => '0', -- 1-bit cascade Master/Slave input
         SHIFTIN2 => '0' -- 1-bit cascade Master/Slave input
      );

test_word <= q4 & q3 & q2 & q1;
test_word_d <= q4_d & q3_d & q2_d & q1_d;

process (reset, RCV_CLKDIV)
variable index, index_2 : integer;
begin
 if reset = '1' then
    q1_d <= '0';
    q2_d <= '0';
    q3_d <= '0';
    q4_d <= '0';
    locked <= '0';
    test_ch_1 <= "00";
    test_ch_2 <= "000";
    bs_state <= IDLE;
    start_train_flag <= '0';
    end_train_flag <= '0';
    daq_ready_flag <= '0';
    crc_init <= x"FF";
 elsif rising_edge (RCV_CLKDIV) then
    button_2_pushed_d <= button_2_pushed;
    q1_d <= q1;
    q2_d <= q2;
    q3_d <= q3;
    q4_d <= q4;

    case state is 
      when first =>
        case test_word is
          when "0101" =>
           bitslip <= '0';
           if test_word_d = "1000" then
           locked <= '1';
           state <= fourth;
           end if;
         when "1000" =>
           bitslip <= '0';
           if test_word_d = "0101" then
           locked <= '1';
           state <= fourth;
           end if;
         when "0000" =>
           if test_word_d = "1011" then 
           bitslip <= '1';
           state <= second;
           end if; 
           locked <= '0';         
         when "1011" =>
           if test_word_d = "0000" then
           bitslip <= '1';
           state <= second;
           end if;
           locked <= '0';
         when "0001" =>
           if test_word_d = "0110" then
           bitslip <= '1';
           state <= second;
           end if;
           locked <= '0';
         when "0110" =>
           if test_word_d = "0001" then
           bitslip <= '1';
           state <= second;
           end if;
           locked <= '0';
         when "1100" =>
           if test_word_d = "0010" then
           bitslip <= '1';
           state <= second;
           end if;
           locked <= '0';
         when "0010" =>
           if test_word_d = "1100" then
           bitslip <= '1';
           state <= second;
           end if;
           locked <= '0';
         when others =>
        end case;
       when second =>
         bitslip <= '0';
         state <= third;
       when third =>
         state <= first;
       when fourth =>
         locked <= '1';
       when others =>
    end case;
   
    case bs_state is 
      when IDLE =>
         data_flag <= '0';
         write_flag_t <= "00000";
         crc_init <= x"FF";
         crc_ok <= '0';
         data_counter <= 0;
         if locked = '1' then
            if test_word = "1100" and test_word_d = "0010" then
               bs_state <= run_1;
            end if;
         end if;
      when run_1 =>
         index := find_one_2 (test_word);
          case index is 
          when 0 => 
             start_train_flag <= '1';
             
          when 1 => 
             end_train_flag <= '1';
             
          when 2 => 
             daq_ready_flag <= '1';
             
          when others => 
            
          end case;
          bs_state <= run_2;
         
      when run_2 =>
              
         index_2 := find_one_2 (test_word);
         if index_2 = 0 then
            data_flag <= '0';
            bs_state <= run_3;
         elsif index_2 = 1 then
            bs_state <= run_3;
            data_flag <= '1';
         else
            crc_init <= crc_8_gen ((test_word_d & test_word) , crc_init);
            bs_state <= run_5;
         end if;
         header <= test_word_d & test_word;
           
      when run_3 =>
          if data_counter mod 2 = 1 then
             crc_init <= crc_8_gen ((test_word_d & test_word) , crc_init);
          end if;
          if data_counter < 7 then
            if data_flag = '0' then
               train_no <= train_no (27 downto 0) & test_word;
            else
               bunch_pattern <= bunch_pattern (27 downto 0) & test_word;
            end if;
            data_counter <= data_counter + 1;
            bs_state <= run_3;
          elsif data_counter = 7 then
            if data_flag = '0' then
               train_no <= train_no (27 downto 0) & test_word;
            else
               bunch_pattern <= bunch_pattern (27 downto 0) & test_word;
            end if;
            data_counter <= 0;
            bs_state <= run_4;
          end if;
      
      when run_4 =>
          if data_counter = 1 then
            crc_init <= crc_8_gen ((test_word_d & test_word) , crc_init);
            data_counter <= 0;
            bs_state <= crc_check;
          else
            data_counter <= data_counter + 1;
            crc_init <= crc_8_gen ( header , crc_init);
          end if;
      
      when run_5 =>
          if data_counter = 1 then
            crc_init <= crc_8_gen ((test_word_d & test_word) , crc_init);
            data_counter <= 0;
            bs_state <= crc_check;
          else
            data_counter <= data_counter + 1;
          end if;
      
      when crc_check =>
          if crc_init = x"00" then
             bs_state <= IDLE;
             --if index >=0 then
                write_flag_t (index) <= '1';
             --end if;
             if index_2 >= 0 then
                write_flag_t (index_2 +3) <= '1';
             end if;
             crc_ok <= '1';
          else
             crc_ok <= '0';
             bs_state <= IDLE;
             write_flag_t <= "00000";
          end if;
      
      when others =>
    end case; 
 end if;
 
end process;

train_no_out <= train_no;
bunch_pattern_out <= bunch_pattern;


clkout27 <= RCV_CLKDIV;
write_flag <= write_flag_t;

---Chipscope core -- The icon core should be instantiated in the top level if they need to be used.

your_instance_name_4 : ila_second
  port map (
    CONTROL => control_2,
    CLK => RCV_CLKDIV,
    TRIG0 => TRIG0);

trig0 <= train_no & bunch_pattern & write_flag_t & test_word(3) & test_word(2) & test_word(1) & test_word(0) & crc_ok & button_2_pushed & crc_init & locked;

end Behavioral;

