----------------------------------------------------------------------------------
-- Company: UCL
-- Engineer: EM
-- 
-- Create Date:    11:16:48 09/20/2010 
-- Design Name: 
-- Module Name:    test_telegram - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
library UNISIM;
use UNISIM.VComponents.all;

use work.crc_gen_pkg.all;

entity test_telegram is
    Port ( write_clk : in  STD_LOGIC;
           wr_en     : in  STD_LOGIC;
           wr_type   : in  STD_LOGIC_VECTOR (7 downto 0);
           wr_data   : in  STD_LOGIC_VECTOR (7 downto 0);
           reset     : in  STD_LOGIC;
           clk108    : in  STD_LOGIC;
           tel_data_out : out  STD_LOGIC_VECTOR (1 downto 0);
           tel_clk_out  : out  STD_LOGIC_VECTOR (1 downto 0);
           control_0    : inout std_logic_vector (35 downto 0);  --- For the chipscope cores -- Can be commented if not used
           control_1    : inout std_logic_vector (35 downto 0);  --- For the chipscope cores -- Can be commented if not used
           vio_out1     : out std_logic_vector (1 downto 0)--- For the chipscope cores -- Can be commented if not used
           );
end test_telegram;

architecture Behavioral of test_telegram is

constant start_packet : std_logic_vector (7 downto 0) := "00101100";

signal di    : std_logic_vector (15 downto 0);
signal empty : std_logic;
signal full  : std_logic;
signal do    : std_logic_vector (15 downto 0);
signal rst   : std_logic;
signal rdclk : std_logic;
signal rden  : std_logic;
type   state_type is (IDLE,READ_1,READ_2);
signal state    : state_type;
signal reg_data : std_logic_vector (15 downto 0);

signal train_number_reg : std_logic_vector (31 downto 0);
signal bunch_pattern_index_reg : std_logic_vector (31 downto 0);
signal start_train_reg : std_logic;
signal end_train_reg : std_logic;
signal daq_ready_reg : std_logic;
signal data_sent     : std_logic_vector (55 downto 0);
signal tr_no_count   : integer range 0 to 4;
signal bun_pat_count : integer range 0 to 4;
signal data_send_count : integer range 0 to 56;
type transmit_state_type is (IDLE_T, START, DAQ_READY, TRAIN_NO, BUNCH_NO, END_TRAIN, TRANSMIT);
signal transmit_state : transmit_state_type;
signal crc : std_logic_vector (7 downto 0);
signal data_out : std_logic;
signal start_train_reg_flagged : std_logic;
signal end_train_reg_flagged : std_logic;
signal daq_ready_reg_flagged : std_logic;
signal train_no_flagged : std_logic;
signal bun_pat_flagged  :std_logic;
signal fifo_read_stop : std_logic;
signal run_flag : std_logic;

signal trig_0    : std_logic_vector (105 downto 0);
signal temp_trig : std_logic_vector (78 downto 0);

signal crc_train_no : std_logic_vector (7 downto 0) := CRC_INIT_VAL;
signal crc_bunch_pattern : std_logic_vector (7 downto 0) := CRC_INIT_VAL;
signal idle_pattern : std_logic_vector (15 downto 0) := x"5858";
signal idle_index : integer range 0 to 4;

component chipscope_ila
  PORT (
    CONTROL : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0);
    CLK : IN STD_LOGIC;
    TRIG0 : IN STD_LOGIC_VECTOR(105 DOWNTO 0));

end component;

component chipscope_vio
  PORT (
    CONTROL : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0);
    ASYNC_OUT : OUT STD_LOGIC_VECTOR(1 DOWNTO 0));

end component;


begin

di <= wr_data & wr_type;
rst <= reset;


FIFO18_inst : FIFO18
   generic map (
    ALMOST_FULL_OFFSET => X"080", -- Sets almost full threshold
    ALMOST_EMPTY_OFFSET => X"080", -- Sets the almost empty threshold
    DATA_WIDTH => 18, -- Sets data width to 4, 9, or 18
    DO_REG => 1, -- Enable output register ( 0 or 1)    -- Must be 1 if the EN_SYN = FALSE
    EN_SYN => FALSE, -- Specified FIFO as Asynchronous (FALSE) or    -- Synchronous (TRUE)
    FIRST_WORD_FALL_THROUGH => FALSE, -- Sets the FIFO FWFT to TRUE or FALSE
    SIM_MODE => "SAFE") -- Simulation: "SAFE" vs "FAST", see "Synthesis and Simulation Design Guide" for details
  
  port map (
   ALMOSTEMPTY => open, -- 1-bit almost empty output flag
   ALMOSTFULL => open, -- 1-bit almost full output flag
   DO => DO, -- 32-bit data output
   DOP => open, -- 2-bit parity data output
   EMPTY => EMPTY, -- 1-bit empty output flag
   FULL => FULL, -- 1-bit full output flag
   RDCOUNT => open, -- 12-bit read count output
   RDERR => open, -- 1-bit read error output
   WRCOUNT => open, -- 12-bit write count output
   WRERR => open, -- 1-bit write error
   DI => DI, -- 16-bit data input
   DIP => "00", -- 2-bit parity input
   RDCLK => clk108, -- 1-bit read clock input
   RDEN => RDEN, -- 1-bit read enable input
   RST => RST, -- 1-bit reset input
   WRCLK => write_clk, -- 1-bit write clock input
   WREN => wr_en -- 1-bit write enable input
  );


fifo_read : process (reset,clk108)
variable index : integer;
begin
if reset = '1' then
   state <= IDLE;
elsif rising_edge (clk108) then
   if start_train_reg_flagged = '1' then
      start_train_reg <= '0';
   end if; 
   if end_train_reg_flagged = '1' then
      end_train_reg <= '0';
   end if;
   if daq_ready_reg_flagged = '1' then
      daq_ready_reg <= '0';
   end if;
   if train_no_flagged = '1'then
      tr_no_count <= 0;
      crc_train_no <= x"FF";
   end if;
   if bun_pat_flagged = '1' then
      bun_pat_count <= 0;
      crc_bunch_pattern <= x"FF";
   end if;
   case state is
    when IDLE =>
         if empty = '0' and run_flag = '0' then 
           rden <= '1';
           state <= READ_1;
        else
           rden <= '0';
        end if; 
    when READ_1 =>
        state <= READ_2;
        rden <= '0';
    when READ_2 =>
        state <= IDLE;
          index := find_one (do (7 downto 0));
          case index is
           when 0 => 
               train_number_reg <= train_number_reg(23 downto 0) & do (15 downto 8);
               tr_no_count <= tr_no_count + 1;
               crc_train_no <= crc_8_gen (do(15 downto 8),crc_train_no);
           when 1 =>
               bunch_pattern_index_reg <= bunch_pattern_index_reg(23 downto 0) & do (15 downto 8);
               bun_pat_count <= bun_pat_count + 1;
               crc_bunch_pattern <= crc_8_gen (do(15 downto 8), crc_bunch_pattern);
           when 4 =>
               start_train_reg <= '1';
           when 5 =>
               end_train_reg <= '1';
               state <= IDLE;
               rden <= '0';
           when 6 =>
               daq_ready_reg <= '1';
           when others =>
          end case;
     when others =>
   end case;
   
end if;
end process;


transmit_proc : process (reset, clk108)
variable crc_event : std_logic_vector (7 downto 0);
begin
if reset = '1' then
   transmit_state <= IDLE_T;
   run_flag <= '0';
   data_out <= '0';
   idle_index <= 0;
elsif rising_edge (clk108) then
   case transmit_state is
   when IDLE_T =>
     
     crc <= CRC_INIT_VAL;
     if start_train_reg = '1' then 
        data_sent <= start_packet & data_sent (47 downto 0);
        transmit_state <= START; 
        start_train_reg_flagged <= '1';  
        run_flag <= '1'; 
               
     elsif daq_ready_reg = '1' then
        data_sent <= start_packet & data_sent (47 downto 0);
        transmit_state <= DAQ_READY;
        daq_ready_reg_flagged <= '1';
        run_flag <= '1'; 
     elsif tr_no_count = 4 then
        data_sent <= start_packet & "0000" & "0001" & data_sent (39 downto 0);
        transmit_state <= TRAIN_NO;
        train_no_flagged <= '1';
        run_flag <= '1'; 
        crc <= crc_8_gen ("00000001", crc_train_no);
     elsif bun_pat_count = 4 then
        data_sent <= start_packet & "0000" & "0010" & data_sent (39 downto 0);
        transmit_state <= BUNCH_NO;
        bun_pat_flagged <= '1';
        run_flag <= '1'; 
        crc <= crc_8_gen ("00000010", crc_bunch_pattern);
     elsif end_train_reg = '1' then
        data_sent <= start_packet & data_sent (47 downto 0);
        transmit_state <= END_TRAIN;
        end_train_reg_flagged <= '1';
        run_flag <= '1'; 
     else 
        transmit_state <= IDLE_T;
     end if;
     
   when START =>
      start_train_reg_flagged <= '0'; 
      if tr_no_count = 4 then
         data_sent <= data_sent (55 downto 48) & "0001" & "0001" & data_sent (39 downto 0);
         transmit_state <= TRAIN_NO;
         train_no_flagged <= '1';
         crc <= crc_8_gen ("00010001",crc_train_no);
      elsif bun_pat_count = 4 then
         data_sent <= data_sent (55 downto 48) & "0001" & "0010" & data_sent (39 downto 0);
         transmit_state <= BUNCH_NO;
         bun_pat_flagged <= '1';
         crc <= crc_8_gen ("00010010", crc_bunch_pattern);
      else
         if idle_index = 3 then
            crc_event := crc_8_gen("00010000", crc);
            data_sent <= data_sent (55 downto 48) & "0001" & "0000" & crc_event & data_sent (31 downto 0);
            transmit_state <= TRANSMIT;
            data_send_count <= 23; --24;
         end if; 
      end if;
     
   when TRAIN_NO =>
        if idle_index = 3 then
          train_no_flagged <= '0';
          data_sent <= data_sent (55 downto 40) & train_number_reg & crc;
          transmit_state <= TRANSMIT;  
          data_send_count <= 55; --56;
        end if;  
                
   when BUNCH_NO =>
        if idle_index = 3 then
          bun_pat_flagged <= '0';
          data_sent <= data_sent (55 downto 40) & bunch_pattern_index_reg & crc;
          transmit_state <= TRANSMIT;
          data_send_count <= 55; --56;
        end if;
   
   when END_TRAIN =>
        if idle_index = 3 then
           crc_event := crc_8_gen("00100000", crc);
           end_train_reg_flagged <= '0';
           data_sent <= data_sent (55 downto 48) & "0010" & "0000" & crc_event & data_sent (31 downto 0);
           transmit_state <= TRANSMIT;
           data_send_count <= 23;--24;
        end if;
        run_flag <= '1'; 
  
  when DAQ_READY =>
        if idle_index = 3 then
           crc_event := crc_8_gen("01000000", crc);
           daq_ready_reg_flagged <= '0';
           data_sent <=  data_sent (55 downto 48) & "0100" & "0000" & crc_event & data_sent (31 downto 0);
           transmit_state <= TRANSMIT;
           data_send_count <= 23;--24;
        end if;
  
  when TRANSMIT =>
        data_out <= data_sent (55);
        data_sent <= data_sent (54 downto 0) & '0';
        data_send_count <= data_send_count - 1;
        if data_send_count = 0 then
           transmit_state <= IDLE_T;
           run_flag <= '0';
        end if;
   when others =>
   end case;
   
   if transmit_state /= TRANSMIT then
      idle_pattern <= idle_pattern (14 downto 0) & idle_pattern (15);
      data_out <= idle_pattern (15);
      if idle_index = 3 then
         idle_index <= 0;
      else
         idle_index <= idle_index + 1;
      end if;
   end if;      

end if;
end process;


lvds_out : OBUFDS port map (
           I  => data_out, 
			  O  => tel_data_out(0),
			  OB => tel_data_out(1)
			  );

lvds_out2 : OBUFDS port map (
           I  => clk108,
			  O  => tel_clk_out(0),
			  OB => tel_clk_out(1)
			  );

---Chipscope cores -- The icon core should be instantiated in the top level if they need to be used.

    
your_instance_name_2 : chipscope_ila
  port map (
    CONTROL => control_0,
    CLK => clk108,
    TRIG0 => trig_0);

trig_0 <= conv_std_logic_vector (idle_index, 3) & crc_train_no &  crc & conv_std_logic_vector (tr_no_count,3) & end_train_reg & start_train_reg & daq_ready_reg & rden & empty &
          di (15 downto 0) & data_sent (55 downto 8) & conv_std_logic_vector (data_send_count,6) & data_out & 
          conv_std_logic_vector (bun_pat_count,3)  & "00000" ;
temp_trig <= (others => '0');

your_instance_name_3 : chipscope_vio
  port map (
    CONTROL => control_1,
    ASYNC_OUT => vio_out1);


end Behavioral;

