-- VHDL Entity hybrid.bcc_digital_top.symbol
--
-- Created:
--          by - Matt Warren
--          at - 16:55:50 03/09/09
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2008.1 (Build 17)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

entity bcc_digital_top is
   port( 
      clk         : in     std_logic;
      clk2x       : in     std_logic;
      com         : in     std_logic;
      data0       : in     std_logic;
      data1       : in     std_logic;
      data2       : in     std_logic;
      data3       : in     std_logic;
      id          : in     std_logic_vector (5 downto 0);
      l1r         : in     std_logic;
      por         : in     std_logic;
      abcn_bco    : out    std_logic;
      abcn_com    : out    std_logic;
      abcn_dclk   : out    std_logic;
      abcn_l1     : out    std_logic;
      abcn_mode80 : out    std_logic;
      abcn_resetb : out    std_logic;
      dataout     : out    std_logic
   );

-- Declarations

end bcc_digital_top ;

-- UCL HEP  Project:  ATLAS_Tracker_Upgrade  
-- by Matt Warren, warren@hep.ucl.ac.uk  
--                                       
-- Title:  BCC Digital Top Level  
-- Path:  hybrid/bcc_digital_top/struct  
-- Edited:  by warren on 09 Mar 2009  
--
-- VHDL Architecture hybrid.bcc_digital_top.struct
--
-- Created:
--          by - Matt Warren
--          at - 16:55:50 03/09/09
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2008.1 (Build 17)
--
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;


architecture struct of bcc_digital_top is

   -- Architecture declarations

   -- Internal signal declarations
   signal clk_locked   : std_logic;
   signal comdest      : std_logic_vector(1 downto 0);
   signal config_reg   : std_logic_vector(15 downto 0);
   signal l1r_rstn     : std_logic;
   signal local_com    : std_logic;
   signal local_data   : std_logic;
   signal local_l1     : std_logic;
   signal local_resetb : std_logic;
   signal rstn         : std_logic;


   -- Component Declarations
   component bcc_control
   port (
      abcn_dclk_o    : out    std_logic ;
      abcn_bco_o     : out    std_logic ;
      abcn_mode80_o  : out    std_logic ;
      abcn_com_o     : out    std_logic ;
      abcn_resetb_o  : out    std_logic ;
      abcn_l1_o      : out    std_logic ;
      local_com_i    : in     std_logic ;
      local_l1_i     : in     std_logic ;
      local_resetb_i : in     std_logic ;
      data0_i        : in     std_logic ;
      data1_i        : in     std_logic ;
      data2_i        : in     std_logic ;
      data3_i        : in     std_logic ;
      local_data_o   : out    std_logic ;
      config_reg_i   : in     std_logic_vector (15 downto 0);
      comdest_i      : in     std_logic_vector (1 downto 0);
      rstn           : in     std_logic ;
      clk            : in     std_logic ;
      clk2x          : in     std_logic 
   );
   end component;
   component bcc_decoder
   port (
      id_i         : in     std_logic_vector (5 downto 0);
      com_i        : in     std_logic ;
      data_o       : out    std_logic ;
      local_com_o  : out    std_logic ;
      local_data_i : in     std_logic ;
      config_reg_o : out    std_logic_vector (15 downto 0);
      comdest_o    : out    std_logic_vector (1 downto 0);
      por          : in     std_logic ;
      rstn         : in     std_logic ;
      clk          : in     std_logic 
   );
   end component;
   component count_delay
   generic (
      BITS : integer := 16
   );
   port (
      done : out    std_logic ;
      por  : in     std_logic ;
      clk  : in     std_logic 
   );
   end component;
   component l1r_decoder
   port (
      l1r_i          : in     std_logic ;
      local_l1_o     : out    std_logic ;
      local_resetb_o : out    std_logic ;
      l1r_rstn_o     : out    std_logic ;
      por            : in     std_logic ; -- low true
      clk            : in     std_logic 
   );
   end component;


begin

   -- ModuleWare code(v1.9) for instance 'U_0' of 'and'
   rstn <= clk_locked and por and l1r_rstn;

   -- Instance port mappings.
   Ucontrol : bcc_control
      port map (
         abcn_dclk_o    => abcn_dclk,
         abcn_bco_o     => abcn_bco,
         abcn_mode80_o  => abcn_mode80,
         abcn_com_o     => abcn_com,
         abcn_resetb_o  => abcn_resetb,
         abcn_l1_o      => abcn_l1,
         local_com_i    => local_com,
         local_l1_i     => local_l1,
         local_resetb_i => local_resetb,
         data0_i        => data0,
         data1_i        => data1,
         data2_i        => data2,
         data3_i        => data3,
         local_data_o   => local_data,
         config_reg_i   => config_reg,
         comdest_i      => comdest,
         rstn           => rstn,
         clk            => clk,
         clk2x          => clk2x
      );
   Udecoder : bcc_decoder
      port map (
         id_i         => id,
         com_i        => com,
         data_o       => dataout,
         local_com_o  => local_com,
         local_data_i => local_data,
         config_reg_o => config_reg,
         comdest_o    => comdest,
         por          => por,
         rstn         => rstn,
         clk          => clk
      );
   Ucount_delay : count_delay
      generic map (
         BITS => 16
      )
      port map (
         done => clk_locked,
         por  => por,
         clk  => clk
      );
   Ul1r_decoder : l1r_decoder
      port map (
         l1r_i          => l1r,
         local_l1_o     => local_l1,
         local_resetb_o => local_resetb,
         l1r_rstn_o     => l1r_rstn,
         por            => por,
         clk            => clk
      );

end struct;
