--
-- Buffer Controller Chip
-- Counter for start-up delay
--
-- Matt Warren
-- UCL
--
-- Log
-- 2009-Jan-21 - This file is born
-- 2009-Jan-21 - Version 0.2
-- 2009-Jan-26 - Version 0.3
-- 2009-Feb-13 - Version 0.5
-- 2009-Mar-09 - renamed rst to por and inverted 
--             - Version 0.7


library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity count_delay is
  generic(
    BITS :     integer := 16
    );
  port(
    done : out std_logic;
    por  : in  std_logic;
    clk  : in  std_logic
    );

-- Declarations

end count_delay;

--
architecture rtl of count_delay is

  signal count    : std_logic_vector((BITS-1) downto 0);
  signal done_int : std_logic;

begin

  process (clk, por)
  begin
    if (por = '0') then
      count    <= (others => '1');
      done_int <= '0';

    elsif rising_edge(clk) then

      if (count = 0) then
        done_int <= '1';
      end if;

      if (done_int = '0') then
        count <= count - '1';
      end if;

    end if;
  end process;

  done <= done_int;

end architecture rtl;

