--
-- Buffer Controller Chip
-- Command Decoder
--
-- Matt Warren
-- UCL
--
-- Decodes l1r stream and forwards it to bcc_control
-- if needed, or resets decoder sm
--
-- Log:
-- 2009-Feb-12 - This file is born
--             - Split the l1r decoder out from bcc decoder
-- 2009-Feb-13 - Version 0.5
-- 2009-Feb-16 - Changed to using por for reset
--             - Version 0.6
-- 2009-Mar-09 - inverted l1r_rst_o and renamened to l1r_rstn_o
--             - Version 0.7



library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity l1r_decoder is
  port(
    l1r_i          : in  std_logic;
    local_l1_o     : out std_logic;
    local_resetb_o : out std_logic;
    l1r_rstn_o      : out std_logic;
    por            : in  std_logic; -- low true
    clk            : in  std_logic
    );

-- Declarations

end l1r_decoder;

--
architecture rtl of l1r_decoder is


  signal l1r_shiftreg : std_logic_vector(3 downto 0);
  signal l100         : std_logic;
  signal l110         : std_logic;

begin

-- L1/Reset Signal decoder
--------------------------------------------------------------------

  prc_l1r_decode : process (clk, por, l1r_shiftreg)
  begin
    if (por = '0') then
      l1r_shiftreg <= (others => '0');

    elsif rising_edge(clk) then
      l1r_shiftreg <= l1r_shiftreg(2 downto 0) & l1r_i;

    end if;
  end process;


  l100 <= '1' when (l1r_shiftreg(2 downto 0) = "100") else
          '0' when (l1r_shiftreg(3 downto 1) = "100") else
          --'0' when (l1r_shiftreg(4 downto 2) = "100") else  -- not needed 0 anyway
          '0';

  l110 <= '1' when (l1r_shiftreg(2 downto 0) = "110") else
          '1' when (l1r_shiftreg(3 downto 1) = "110") else
          --'0' when (l1r_shiftreg(4 downto 2) = "110") else  -- not needed 0 anyway
          '0';

  local_l1_o     <= l100 or l110;
  local_resetb_o <= '0' when (l1r_shiftreg(3 downto 0) = "1110") else '1';
  l1r_rstn_o     <= '0' when (l1r_shiftreg(3 downto 0) = "1111") else '1';

end architecture rtl;
